
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    oranges = model.addVar(name="oranges", lb=0)
    milkshakes = model.addVar(name="milkshakes", lb=0)
    pickles = model.addVar(name="pickles", lb=0)

    # Define the objective function
    model.setObjective(2.69 * oranges + 1.69 * milkshakes + 1.85 * pickles, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * oranges + 9 * milkshakes + 10 * pickles <= 127, name="total_fat")
    model.addConstr(11 * oranges + 16 * milkshakes + 13 * pickles <= 129, name="total_carbohydrates")
    model.addConstr(2 * oranges + 10 * pickles >= 33, name="fat_oranges_pickles")
    model.addConstr(2 * oranges + 9 * milkshakes >= 36, name="fat_oranges_milkshakes")
    model.addConstr(2 * oranges + 9 * milkshakes + 10 * pickles >= 36, name="total_fat_all")
    model.addConstr(11 * oranges + 13 * pickles >= 31, name="carbohydrates_oranges_pickles")
    model.addConstr(11 * oranges + 16 * milkshakes >= 25, name="carbohydrates_oranges_milkshakes")
    model.addConstr(11 * oranges + 16 * milkshakes + 13 * pickles >= 25, name="total_carbohydrates_all")
    model.addConstr(-8 * oranges + 4 * milkshakes >= 0, name="oranges_milkshakes_relation")
    model.addConstr(2 * milkshakes - 9 * pickles >= 0, name="milkshakes_pickles_relation")
    model.addConstr(9 * milkshakes + 10 * pickles <= 91, name="fat_milkshakes_pickles")
    model.addConstr(16 * milkshakes + 13 * pickles <= 97, name="carbohydrates_milkshakes_pickles")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Oranges: {oranges.varValue}")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Pickles: {pickles.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
