
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="cans_of_coffee")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")


    # Set objective function
    m.setObjective(4.13 * x0 + 4.5 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10 * x0 + 8 * x1 >= 32, "c0")
    m.addConstr(7 * x0 + 17 * x1 >= 34, "c1")
    m.addConstr(13 * x0 + 11 * x1 >= 25, "c2")
    m.addConstr(8 * x0 - 3 * x1 >= 0, "c3")
    m.addConstr(10 * x0 + 8 * x1 <= 82, "c4")
    m.addConstr(7 * x0 + 17 * x1 <= 94, "c5")
    m.addConstr(13 * x0 + 11 * x1 <= 25, "c6")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        print(f"cans of coffee: {x0.x}")
        print(f"paper clips: {x1.x}")
        print(f"Objective value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
