
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables to the model
x1 = model.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")
x2 = model.addVar(vtype=GRB.INTEGER, name="paper_clips")

# Set the objective function
model.setObjective(4.13*x1 + 4.5*x2, GRB.MINIMIZE)

# Add constraints to the model
model.addConstr(10*x1 + 8*x2 >= 32, "usefulness_rating")
model.addConstr(7*x1 + 17*x2 >= 34, "sustainability_score")
model.addConstr(13*x1 + 11*x2 >= 25, "employee_satisfaction_impact_lower")
model.addConstr(8*x1 - 3*x2 >= 0, "additional_linear_constraint")
model.addConstr(10*x1 + 8*x2 <= 82, "usefulness_rating_upper_bound")
model.addConstr(7*x1 + 17*x2 <= 94, "sustainability_score_upper_bound")
model.addConstr(13*x1 + 11*x2 <= 25, "employee_satisfaction_impact_upper")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"cans_of_coffee: {x1.x}")
    print(f"paper_clips: {x2.x}")
else:
    print("No optimal solution found")
