
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cans_of_coffee", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="paper_clips", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4.13 * x1 + 4.5 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 8 * x2 >= 32)
    model.addConstr(7 * x1 + 17 * x2 >= 34)
    model.addConstr(13 * x1 + 11 * x2 >= 25)
    model.addConstr(8 * x1 - 3 * x2 >= 0)
    model.addConstr(10 * x1 + 8 * x2 <= 82)
    model.addConstr(7 * x1 + 17 * x2 <= 94)
    model.addConstr(13 * x1 + 11 * x2 <= 25)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cans of coffee: {x1.varValue}")
        print(f"Paper clips: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
