
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams of magnesium") # Integer variable
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="grams of carbohydrates") # Continuous variable

# Set objective function
m.setObjective(7.49*x0**2 + 1.91*x1**2 + 1.27*x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x0 + 2*x1 >= 26, "immune_support_lower")
m.addConstr(20*x0 + 5*x1 >= 38, "cognitive_performance_lower")
m.addConstr(x0 + 7*x1 >= 9, "muscle_growth_lower")
m.addConstr(16*x0 + 18*x1 >= 32, "energy_stability_lower")
m.addConstr(-10*x0 + 9*x1 >= 0, "constraint_5")
m.addConstr(8*x0 + 2*x1 <= 69, "immune_support_upper")
m.addConstr(20*x0 + 5*x1 <= 122, "cognitive_performance_upper")
m.addConstr(x0 + 7*x1 <= 44, "muscle_growth_upper")
m.addConstr(16*x0 + 18*x1 <= 59, "energy_stability_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('milligrams of magnesium:', x0.x)
    print('grams of carbohydrates:', x1.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

