
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_magnesium", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="grams_of_carbohydrates")

    # Objective function
    model.setObjective(7.49 * x1**2 + 1.91 * x2**2 + 1.27 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8 * x1 <= 72)
    model.addConstr(20 * x1 <= 136)
    model.addConstr(x1 <= 50)
    model.addConstr(16 * x1 <= 119)

    model.addConstr(2 * x2 <= 72)
    model.addConstr(5 * x2 <= 136)
    model.addConstr(7 * x2 <= 50)
    model.addConstr(18 * x2 <= 119)

    model.addConstr(8**2 * x1**2 + 2**2 * x2**2 >= 26)
    model.addConstr(20 * x1 + 5 * x2 >= 38)
    model.addConstr(x1 + 7 * x2 >= 9)
    model.addConstr(16 * x1 + 18 * x2 >= 32)
    model.addConstr(-10 * x1 + 9 * x2 >= 0)

    model.addConstr(8 * x1 + 2 * x2 <= 69)
    model.addConstr(20 * x1**2 + 5**2 * x2**2 <= 122)
    model.addConstr(20 * x1 + 5 * x2 <= 122)
    model.addConstr(x1 + 7 * x2 <= 44)
    model.addConstr(16 * x1**2 + 18**2 * x2**2 <= 59)
    model.addConstr(16 * x1 + 18 * x2 <= 59)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of magnesium: {x1.varValue}")
        print(f"Grams of carbohydrates: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
