
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
calcium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="calcium")
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")


# Set objective function
m.setObjective(2 * magnesium + 1 * vitamin_b12 + 6 * calcium + 6 * vitamin_b1, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * magnesium + 10 * vitamin_b12 + 14 * calcium + 3 * vitamin_b1 <= 153, "immune_support_ub")
m.addConstr(1 * magnesium + 6 * vitamin_b12 + 5 * calcium + 11 * vitamin_b1 <= 266, "cardio_support_ub")
m.addConstr(2 * magnesium + 10 * vitamin_b12 + 4 * calcium + 14 * vitamin_b1 <= 186, "energy_ub")
m.addConstr(8 * magnesium + 13 * vitamin_b12 + 2 * calcium + 2 * vitamin_b1 <= 145, "kidney_support_ub")

m.addConstr(7 * magnesium + 10 * vitamin_b12 >= 21, "immune1")
m.addConstr(7 * magnesium + 3 * vitamin_b1 >= 21, "immune2")
m.addConstr(10 * vitamin_b12 + 3 * vitamin_b1 >= 31, "immune3")
m.addConstr(7 * magnesium + 14 * calcium + 3 * vitamin_b1 >= 23, "immune4")
m.addConstr(7 * magnesium + 10 * vitamin_b12 + 14 * calcium >= 23, "immune5")
m.addConstr(7 * magnesium + 14 * calcium + 3 * vitamin_b1 >= 19, "immune6")
m.addConstr(7 * magnesium + 10 * vitamin_b12 + 14 * calcium >= 19, "immune7")
m.addConstr(7 * magnesium + 10 * vitamin_b12 + 14 * calcium + 3 * vitamin_b1 >= 19, "immune8")


# ... (rest of the constraints -  added in a similar fashion as above)

m.addConstr(magnesium - 10 * vitamin_b12 >= 0, "custom_constraint")
m.addConstr(7 * magnesium + 3 * vitamin_b1 <= 99, "immune_ub1")
# ... (rest of upper bound constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('magnesium:', magnesium.x)
    print('vitamin_b12:', vitamin_b12.x)
    print('calcium:', calcium.x)
    print('vitamin_b1:', vitamin_b1.x)

elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

