
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B9
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B1
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin K
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B3


# Set objective function
m.setObjective(8.52 * x0 + 6.24 * x1 + 3.36 * x2 + 9.23 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * x1 + 8 * x2 >= 7)
m.addConstr(9 * x0 + 8 * x2 >= 18)
m.addConstr(8 * x2 + 10 * x3 >= 22)
m.addConstr(9 * x0 + 8 * x1 >= 10)
m.addConstr(9 * x0 + 10 * x3 >= 17)
m.addConstr(9 * x0 + 8 * x1 + 8 * x2 + 10 * x3 >= 17)
m.addConstr(9 * x2 + 8 * x3 >= 11)
m.addConstr(7 * x0 + 9 * x2 >= 7)
m.addConstr(7 * x0 + 7 * x1 + 9 * x2 + 8 * x3 >= 7)
m.addConstr(3 * x0 + 1 * x2 >= 6)
m.addConstr(7 * x1 + 1 * x2 >= 10)
m.addConstr(1 * x2 + 2 * x3 >= 6)
m.addConstr(7 * x1 + 2 * x3 >= 7)
m.addConstr(3 * x0 + 7 * x1 >= 4)
m.addConstr(3 * x0 + 2 * x3 >= 11)
m.addConstr(3 * x0 + 7 * x1 + 1 * x2 + 2 * x3 >= 11)
m.addConstr(-6 * x1 + 10 * x3 >= 0)
m.addConstr(-5 * x0 + 9 * x3 >= 0)
m.addConstr(7 * x1 - 7 * x2 >= 0)
m.addConstr(8 * x1 + 10 * x3 <= 54)
m.addConstr(9 * x0 + 8 * x2 <= 64)
m.addConstr(8 * x2 + 10 * x3 <= 55)
m.addConstr(9 * x0 + 10 * x3 <= 76)
m.addConstr(7 * x0 + 7 * x1 <= 34)
m.addConstr(7 * x0 + 9 * x2 <= 41)
m.addConstr(7 * x1 + 9 * x2 <= 17)
m.addConstr(9 * x2 + 8 * x3 <= 35)
m.addConstr(3 * x0 + 2 * x3 <= 24)
m.addConstr(7 * x1 + 2 * x3 <= 43)
m.addConstr(3 * x0 + 7 * x1 <= 27)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

