
import gurobi

def optimize_vitamins():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin B9
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B1
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin K
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B3

    # Objective function
    model.setObjective(8.52 * x0 + 6.24 * x1 + 3.36 * x2 + 9.23 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * x0 + 8 * x1 + 8 * x2 + 10 * x3 <= 94)
    model.addConstr(7 * x0 + 7 * x1 + 9 * x2 + 8 * x3 <= 57)
    model.addConstr(3 * x0 + 7 * x1 + x2 + 2 * x3 <= 49)
    model.addConstr(8 * x1 + 8 * x2 >= 7)
    model.addConstr(9 * x0 + 8 * x2 >= 18)
    model.addConstr(8 * x2 + 10 * x3 >= 22)
    model.addConstr(9 * x0 + 8 * x1 >= 10)
    model.addConstr(9 * x0 + 10 * x3 >= 17)
    model.addConstr(9 * x0 + 8 * x1 + 8 * x2 + 10 * x3 >= 17)
    model.addConstr(9 * x2 + 8 * x3 >= 11)
    model.addConstr(7 * x0 + 9 * x2 >= 7)
    model.addConstr(7 * x0 + 7 * x1 + 9 * x2 + 8 * x3 >= 7)
    model.addConstr(3 * x0 + x2 >= 6)
    model.addConstr(7 * x1 + x2 >= 10)
    model.addConstr(x2 + 2 * x3 >= 6)
    model.addConstr(7 * x1 + 2 * x3 >= 7)
    model.addConstr(3 * x0 + 7 * x1 >= 4)
    model.addConstr(3 * x0 + 2 * x3 >= 11)
    model.addConstr(3 * x0 + 7 * x1 + x2 + 2 * x3 >= 11)
    model.addConstr(-6 * x1 + 10 * x3 >= 0)
    model.addConstr(-5 * x0 + 9 * x3 >= 0)
    model.addConstr(7 * x1 - 7 * x2 >= 0)
    model.addConstr(8 * x1 + 10 * x3 <= 54)
    model.addConstr(9 * x0 + 8 * x2 <= 64)
    model.addConstr(8 * x2 + 10 * x3 <= 55)
    model.addConstr(9 * x0 + 10 * x3 <= 76)
    model.addConstr(7 * x0 + 7 * x1 <= 34)
    model.addConstr(7 * x0 + 9 * x2 <= 41)
    model.addConstr(7 * x1 + 9 * x2 <= 17)
    model.addConstr(9 * x2 + 8 * x3 <= 35)
    model.addConstr(3 * x0 + 2 * x3 <= 24)
    model.addConstr(7 * x1 + 2 * x3 <= 43)
    model.addConstr(3 * x0 + 7 * x1 <= 27)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B9: {x0.varValue}")
        print(f"Milligrams of vitamin B1: {x1.varValue}")
        print(f"Milligrams of vitamin K: {x2.varValue}")
        print(f"Milligrams of vitamin B3: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
