
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
laura_hours = m.addVar(vtype=gp.GRB.INTEGER, name="laura_hours")
dale_hours = m.addVar(name="dale_hours")
bobby_hours = m.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
peggy_hours = m.addVar(vtype=gp.GRB.INTEGER, name="peggy_hours")


# Set objective function
m.setObjective(5.85 * laura_hours + 6.48 * dale_hours + 9.25 * bobby_hours + 9.29 * peggy_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * laura_hours + 3 * dale_hours >= 65)
m.addConstr(9 * laura_hours + 5 * peggy_hours >= 29)
m.addConstr(5 * bobby_hours + 5 * peggy_hours >= 26)
m.addConstr(3 * dale_hours + 5 * bobby_hours >= 70)
m.addConstr(9 * laura_hours + 5 * bobby_hours >= 66)
m.addConstr(9 * laura_hours + 3 * dale_hours + 5 * bobby_hours + 5 * peggy_hours >= 66)
m.addConstr(1 * dale_hours + 6 * peggy_hours >= 38)
m.addConstr(9 * laura_hours + 5 * bobby_hours >= 28)
m.addConstr(9 * laura_hours + 1 * dale_hours >= 54)
m.addConstr(5 * bobby_hours + 6 * peggy_hours >= 66)
m.addConstr(9 * laura_hours + 1 * dale_hours + 6 * peggy_hours >= 72)
m.addConstr(9 * laura_hours + 5 * bobby_hours + 6 * peggy_hours >= 72)
m.addConstr(9 * laura_hours + 1 * dale_hours + 6 * peggy_hours >= 51)
m.addConstr(9 * laura_hours + 5 * bobby_hours + 6 * peggy_hours >= 51)
m.addConstr(9 * laura_hours + 1 * dale_hours + 5 * bobby_hours + 6 * peggy_hours >= 51)
m.addConstr(7 * dale_hours + 7 * peggy_hours >= 21)
m.addConstr(10 * laura_hours + 9 * bobby_hours >= 24)
m.addConstr(10 * laura_hours + 7 * dale_hours + 9 * bobby_hours + 7 * peggy_hours >= 24)
m.addConstr(4 * dale_hours + 5 * peggy_hours >= 17)
m.addConstr(5 * laura_hours + 4 * dale_hours >= 15)
m.addConstr(4 * dale_hours + 8 * bobby_hours >= 32)
m.addConstr(8 * bobby_hours + 5 * peggy_hours >= 30)
m.addConstr(5 * laura_hours + 4 * dale_hours + 8 * bobby_hours + 5 * peggy_hours >= 30)
m.addConstr(11 * dale_hours + 2 * peggy_hours >= 35)
m.addConstr(11 * dale_hours + 10 * bobby_hours >= 33)
m.addConstr(10 * bobby_hours + 2 * peggy_hours >= 66)
m.addConstr(6 * laura_hours + 2 * peggy_hours >= 80)
m.addConstr(6 * laura_hours + 11 * dale_hours + 10 * bobby_hours >= 75)
m.addConstr(6 * laura_hours + 11 * dale_hours + 10 * bobby_hours + 2 * peggy_hours >= 75)
m.addConstr(-10 * laura_hours + 8 * bobby_hours >= 0)
m.addConstr(-3 * dale_hours + 4 * peggy_hours >= 0)
m.addConstr(9 * laura_hours + 5 * bobby_hours <= 215)
m.addConstr(9 * laura_hours + 3 * dale_hours + 5 * bobby_hours <= 100)
m.addConstr(9 * laura_hours + 1 * dale_hours + 6 * peggy_hours <= 188)
m.addConstr(1 * dale_hours + 5 * bobby_hours + 6 * peggy_hours <= 206)
m.addConstr(10 * laura_hours + 9 * bobby_hours <= 80)
m.addConstr(10 * laura_hours + 7 * peggy_hours <= 63)
m.addConstr(7 * dale_hours + 7 * peggy_hours <= 75)
m.addConstr(10 * laura_hours + 7 * dale_hours <= 123)
m.addConstr(7 * dale_hours + 9 * bobby_hours + 7 * peggy_hours <= 33)
m.addConstr(10 * laura_hours + 7 * dale_hours + 9 * bobby_hours <= 107)
m.addConstr(10 * laura_hours + 9 * bobby_hours + 7 * peggy_hours <= 48)
m.addConstr(5 * laura_hours + 4 * dale_hours + 8 * bobby_hours <= 108)
m.addConstr(6 * laura_hours + 10 * bobby_hours <= 279)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

