
import gurobipy as gp

# Create a new model
model = gp.Model("resource_allocation")

# Create variables
logistics_companies = model.addVar(vtype=gp.GRB.INTEGER, name="logistics_companies")
signal_platoons = model.addVar(vtype=gp.GRB.INTEGER, name="signal_platoons")
transportation_companies = model.addVar(vtype=gp.GRB.INTEGER, name="transportation_companies")


# Set objective function
model.setObjective(1 * logistics_companies + 9 * signal_platoons + 6 * transportation_companies, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4.57 * logistics_companies + 1.6 * signal_platoons >= 31, "mobility_constraint1")
model.addConstr(4.57 * logistics_companies + 3.13 * transportation_companies >= 23, "mobility_constraint2")
model.addConstr(4.57 * logistics_companies + 1.6 * signal_platoons + 3.13 * transportation_companies >= 55, "mobility_constraint3")
model.addConstr(5 * logistics_companies - 2 * signal_platoons >= 0, "resource_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {model.objVal}")
    print(f"Logistics Companies: {logistics_companies.x}")
    print(f"Signal Platoons: {signal_platoons.x}")
    print(f"Transportation Companies: {transportation_companies.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

