
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="signal_platoons", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="transportation_companies", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(x1 + 9*x2 + 6*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(4.57*x1 + 1.6*x2 >= 31)
m.addConstr(4.57*x1 + 3.13*x3 >= 23)
m.addConstr(4.57*x1 + 1.6*x2 + 3.13*x3 >= 55)
m.addConstr(5*x1 - 2*x2 >= 0)

# Optimize
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Logistics Companies: ", x1.varValue)
    print("Signal Platoons: ", x2.varValue)
    print("Transportation Companies: ", x3.varValue)
else:
    print("The problem is infeasible")
