
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(7, lb=0, vtype=gp.GRB.CONTINUOUS, name=["George", "Hank", "Ringo", "Peggy", "Paul", "John", "Bill"])


# Set objective function
m.setObjective(5*x[0] + 5*x[1] + 9*x[2] + 2*x[3] + 1*x[4] + 2*x[5] + 5*x[6], gp.GRB.MINIMIZE)

# Resource constraints
productivity = {0: 10, 1: 13, 2: 2, 3: 3, 4: 7, 5: 5, 6: 4}
computer_competence = {0: 19, 1: 8, 2: 3, 3: 12, 4: 7, 5: 15, 6: 5}
work_quality = {0: 6, 1: 3, 2: 1, 3: 3, 4: 13, 5: 13, 6: 12}

m.addConstr(gp.quicksum(productivity[i] * x[i] for i in range(7)) <= 334, "r0")
m.addConstr(gp.quicksum(computer_competence[i] * x[i] for i in range(7)) <= 195, "r1")
m.addConstr(gp.quicksum(work_quality[i] * x[i] for i in range(7)) <= 262, "r2")


# Additional constraints
m.addConstr(3*x[3] + 5*x[5] >= 28)
m.addConstr(10*x[0] + 3*x[3] >= 28)
m.addConstr(7*x[4] + 4*x[6] >= 39)
m.addConstr(13*x[1] + 4*x[6] >= 29)
m.addConstr(2*x[2] + 3*x[3] >= 36)
m.addConstr(10*x[0] + 2*x[2] >= 41)
m.addConstr(2*x[2] + 4*x[6] >= 20)
m.addConstr(3*x[3] + 4*x[6] >= 25)
m.addConstr(sum(productivity[i] * x[i] for i in range(7)) >= 25)
m.addConstr(7*x[4] + 15*x[5] >= 17)
m.addConstr(8*x[1] + 5*x[6] >= 15)
m.addConstr(12*x[3] + 7*x[4] >= 20)
m.addConstr(12*x[3] + 15*x[5] >= 16)
m.addConstr(8*x[1] + 15*x[5] >= 11)
m.addConstr(19*x[0] + 7*x[4] >= 16)
m.addConstr(8*x[1] + 12*x[3] >= 15)
m.addConstr(3*x[2] + 15*x[5] >= 21)
m.addConstr(19*x[0] + 3*x[2] >= 21)

# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

