
from gurobipy import *

# Create a new model
m = Model("Work Hours")

# Define variables - Assuming all are non-negative (hours cannot be negative)
x1, x2, x3, x4, x5, x6, x7 = m.addVars(7, lb=0, name=['George', 'Hank', 'Ringo', 'Peggy', 'Paul', 'John', 'Bill'])

# Objective function - Since there's no clear objective, we'll just minimize the total hours worked
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7, GRB.MINIMIZE)

# Example constraint: Total hours worked by George is greater than or equal to 24
m.addConstr(x1 >= 24, name='Min Hours for George')

# Add all other constraints here...
# For example:
# m.addConstr(x2 + x3 >= 50, name='Combined Min Hours for Hank and Ringo')
# ...

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
