
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="George", lb=0)  # hours worked by George
x1 = m.addVar(name="Hank", lb=0)   # hours worked by Hank
x2 = m.addVar(name="Ringo", lb=0)  # hours worked by Ringo
x3 = m.addVar(name="Peggy", lb=0)  # hours worked by Peggy
x4 = m.addVar(name="Paul", lb=0)   # hours worked by Paul
x5 = m.addVar(name="John", lb=0)   # hours worked by John
x6 = m.addVar(name="Bill", lb=0)   # hours worked by Bill

# Objective function
m.setObjective(5*x0 + 5*x1 + 9*x2 + 2*x3 + x4 + 2*x5 + 5*x6, gurobi.GRB.MINIMIZE)

# Constraints
# Productivity rating constraints
m.addConstr(10*x0 + 13*x1 + 2*x2 + 3*x3 + 7*x4 + 5*x5 + 4*x6 <= 334, "Productivity")
m.addConstr(19*x0 + 8*x1 + 3*x2 + 12*x3 + 7*x4 + 15*x5 + 5*x6 <= 195, "Computer_Competence")
m.addConstr(6*x0 + 3*x1 + x2 + 3*x3 + 13*x4 + 13*x5 + 12*x6 <= 262, "Work_Quality")

# Individual productivity constraints
m.addConstr(10*x0 <= 10, "George_Productivity")
m.addConstr(19*x0 <= 19, "George_Computer")
m.addConstr(6*x0 <= 6, "George_Work_Quality")

m.addConstr(13*x1 <= 13, "Hank_Productivity")
m.addConstr(8*x1 <= 8, "Hank_Computer")
m.addConstr(3*x1 <= 3, "Hank_Work_Quality")

m.addConstr(2*x2 <= 2, "Ringo_Productivity")
m.addConstr(3*x2 <= 3, "Ringo_Computer")
m.addConstr(x2 <= 1, "Ringo_Work_Quality")

m.addConstr(3*x3 <= 3, "Peggy_Productivity")
m.addConstr(12*x3 <= 12, "Peggy_Computer")
m.addConstr(3*x3 <= 3, "Peggy_Work_Quality")

m.addConstr(7*x4 <= 7, "Paul_Productivity")
m.addConstr(7*x4 <= 7, "Paul_Computer")
m.addConstr(13*x4 <= 13, "Paul_Work_Quality")

m.addConstr(5*x5 <= 5, "John_Productivity")
m.addConstr(15*x5 <= 15, "John_Computer")
m.addConstr(13*x5 <= 13, "John_Work_Quality")

m.addConstr(4*x6 <= 4, "Bill_Productivity")
m.addConstr(5*x6 <= 5, "Bill_Computer")
m.addConstr(12*x6 <= 12, "Bill_Work_Quality")

# Combined productivity constraints
m.addConstr(3*x3 + 5*x5 >= 28, "Peggy_John_Productivity")
m.addConstr(10*x0 + 3*x3 >= 28, "George_Peggy_Productivity")
m.addConstr(7*x4 + 4*x6 >= 39, "Paul_Bill_Productivity")
m.addConstr(13*x1 + 4*x6 >= 29, "Hank_Bill_Productivity")
m.addConstr(2*x2 + 3*x3 >= 36, "Ringo_Peggy_Productivity")
m.addConstr(10*x0 + 2*x2 >= 41, "George_Ringo_Productivity")
m.addConstr(2*x2 + 4*x6 >= 20, "Ringo_Bill_Productivity")
m.addConstr(3*x3 + 4*x6 >= 25, "Peggy_Bill_Productivity")
m.addConstr(10*x0 + 13*x1 + 2*x2 + 3*x3 + 7*x4 + 5*x5 + 4*x6 >= 25, "Total_Productivity")

# Combined computer competence constraints
m.addConstr(7*x4 + 15*x5 >= 17, "Paul_John_Computer")
m.addConstr(8*x1 + 5*x6 >= 15, "Hank_Bill_Computer")
m.addConstr(12*x3 + 7*x4 >= 20, "Peggy_Paul_Computer")
m.addConstr(12*x3 + 15*x5 >= 16, "Peggy_John_Computer")
m.addConstr(8*x1 + 15*x5 >= 11, "Hank_John_Computer")
m.addConstr(19*x0 + 7*x4 >= 16, "George_Paul_Computer")
m.addConstr(8*x1 + 12*x3 >= 15, "Hank_Peggy_Computer")
m.addConstr(3*x2 + 15*x5 >= 21, "Ringo_John_Computer")
m.addConstr(3*x2 + 19*x0 >= 21, "Ringo_George_Computer")
m.addConstr(3*x2 + 19*x0 + 15*x5 >= 14, "Ringo_George_John_Computer")
m.addConstr(12*x3 + 7*x4 + 15*x5 >= 14, "Peggy_Paul_John_Computer")
m.addConstr(19*x0 + 8*x1 + 12*x3 >= 14, "George_Hank_Peggy_Computer")
m.addConstr(7*x4 + 15*x5 + 5*x6 >= 14, "Paul_John_Bill_Computer")
m.addConstr(3*x2 + 7*x4 + 5*x6 >= 14, "Ringo_Paul_Bill_Computer")
m.addConstr(12*x3 + 7*x4 + 5*x6 >= 14, "Peggy_Paul_Bill_Computer")
m.addConstr(8*x1 + 3*x2 + 7*x4 >= 14, "Hank_Ringo_Paul_Computer")
m.addConstr(8*x1 + 15*x5 + 5*x6 >= 14, "Hank_John_Bill_Computer")
m.addConstr(3*x2 + 5*x6 + 8*x1 >= 14, "Ringo_Bill_Hank_Computer")
m.addConstr(19*x0 + 3*x2 + 7*x4 >= 14, "George_Ringo_Paul_Computer")
m.addConstr(19*x0 + 12*x3 + 5*x6 >= 14, "George_Peggy_Bill_Computer")
m.addConstr(8*x1 + 12*x3 + 15*x5 >= 14, "Hank_Peggy_John_Computer")
m.addConstr(19*x0 + 5*x5 + 5*x6 >= 14, "George_John_Bill_Computer")
m.addConstr(3*x2 + 15*x5 + 5*x6 >= 23, "Ringo_John_Bill_Computer")
m.addConstr(12*x3 + 7*x4 + 15*x5 >= 23, "Peggy_Paul_John_Computer")
m.addConstr(19*x0 + 8*x1 + 12*x3 >= 23, "George_Hank_Peggy_Computer")
m.addConstr(7*x4 + 15*x5 + 5*x6 >= 23, "Paul_John_Bill_Computer")
m.addConstr(3*x2 + 7*x4 + 5*x6 >= 23, "Ringo_Paul_Bill_Computer")

# Work quality constraints
m.addConstr(3*x3 + 13*x4 >= 27, "Peggy_Paul_Work_Quality")
m.addConstr(3*x3 + 12*x6 >= 26, "Peggy_Bill_Work_Quality")
m.addConstr(13*x5 + 12*x6 >= 19, "John_Bill_Work_Quality")
m.addConstr(x2 + 13*x4 >= 12, "Ringo_Paul_Work_Quality")
m.addConstr(3*x1 + 13*x5 >= 22, "Hank_John_Work_Quality")
m.addConstr(3*x1 + 3*x3 >= 33, "Hank_Peggy_Work_Quality")
m.addConstr(x2 + 13*x5 >= 26, "Ringo_John_Work_Quality")
m.addConstr(6*x0 + 3*x1 >= 14, "George_Hank_Work_Quality")
m.addConstr(x2 + 12*x6 >= 36, "Ringo_Bill_Work_Quality")
m.addConstr(13*x4 + 12*x6 >= 33, "Paul_Bill_Work_Quality")
m.addConstr(6*x0 + x2 >= 18, "George_Ringo_Work_Quality")
m.addConstr(3*x1 + 13*x4 >= 27, "Hank_Paul_Work_Quality")
m.addConstr(3*x3 + 13*x4 + 13*x5 >= 22, "Peggy_Paul_John_Work_Quality")
m.addConstr(x2 + 13*x4 + 13*x5 >= 22, "Ringo_Paul_John_Work_Quality")
m.addConstr(3*x3 + 13*x4 + 13*x5 >= 31, "Peggy_Paul_John_Work_Quality")
m.addConstr(x2 + 13*x4 + 13*x5 >= 31, "Ringo_Paul_John_Work_Quality")
m.addConstr(6*x0 + 3*x1 + x2 + 3*x3 + 13*x4 + 13*x5 + 12*x6 >= 31, "Total_Work_Quality")

# Other constraints
m.addConstr(-4*x3 + 3*x4 >= 0, "Peggy_Paul_Constraint")
m.addConstr(9*x0 - x6 >= 0, "George_Bill_Constraint")

# Set bounds for variables based on productivity, computer competence, and work quality
m.addConstr(x0 >= 0)
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)
m.addConstr(x4 >= 0)
m.addConstr(x5 >= 0)
m.addConstr(x6 >= 0)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("George: ", x0.varValue)
    print("Hank: ", x1.varValue)
    print("Ringo: ", x2.varValue)
    print("Peggy: ", x3.varValue)
    print("Paul: ", x4.varValue)
    print("John: ", x5.varValue)
    print("Bill: ", x6.varValue)
else:
    print("No optimal solution found.")
