
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B1
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1")  # milligrams of vitamin B4
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x2")  # milligrams of vitamin B12
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # milligrams of vitamin B7


# Set objective function
m.setObjective(3.31*x0*x1 + 6.06*x0*x3 + 5.47*x1**2 + 6.24*x2**2 + 3.71*x3**2 + 9.53*x0 + 5.69*x1 + 6.96*x2 + 5.28*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x0 + 7*x2 >= 14)
m.addConstr(4*x1 + 6*x3 >= 26)
m.addConstr(4*x1**2 + 11*x2**2 >= 27)
m.addConstr(4*x0 + 11*x2 >= 19)
m.addConstr(11*x2 + 6*x3 >= 17)
m.addConstr(7*x1**2 + 2*x3**2 >= 13)
m.addConstr(7*x0 + 1*x2 + 2*x3 >= 11)
m.addConstr(7*x1 + 1*x2 + 2*x3 >= 11)
m.addConstr(7*x0 + 1*x2 + 2*x3 >= 14)
m.addConstr(7*x1 + 1*x2 + 2*x3 >= 14)
m.addConstr(5*x0 + 6*x3 >= 28)
m.addConstr(5*x0**2 + 10*x2**2 >= 36)
m.addConstr(10*x2**2 + 6*x3**2 >= 17)
m.addConstr(1*x1 + 10*x2 >= 18)
m.addConstr(5*x0 + 1*x1 >= 29)
m.addConstr(5*x0 + 10*x2 + 6*x3 >= 37)
m.addConstr(5*x0 + 1*x1 + 6*x3 >= 37)
m.addConstr(1*x1 + 10*x2 + 6*x3 >= 37)
m.addConstr(5*x0 + 10*x2 + 6*x3 >= 39)
m.addConstr(5*x0 + 1*x1 + 6*x3 >= 39)
m.addConstr(1*x1 + 10*x2 + 6*x3 >= 39)
m.addConstr(5*x0**2 + 10*x2**2 + 6*x3**2 >= 39)
m.addConstr(5*x0**2 + 1*x1**2 + 6*x3**2 >= 39)
m.addConstr(1*x1 + 10*x2 + 6*x3 >= 39)
m.addConstr(3*x1**2 + 1*x3**2 <= 29)
m.addConstr(1*x0**2 + 1*x3**2 <= 91)
m.addConstr(1*x0**2 + 7*x2**2 <= 60)
m.addConstr(7*x2**2 + 1*x3**2 <= 87)
m.addConstr(1*x0 + 3*x1 <= 88)
m.addConstr(1*x0**2 + 3*x1**2 + 7*x2**2 <= 49)
m.addConstr(1*x0 + 3*x1 + 7*x2 + 1*x3 <= 49)
m.addConstr(4*x0**2 + 1*x1**2 <= 75)
m.addConstr(4*x0 + 9*x3 <= 133)
m.addConstr(4*x0 + 5*x2 <= 131)
m.addConstr(5*x2**2 + 9*x3**2 <= 78)
m.addConstr(4*x0 + 5*x2 + 9*x3 <= 51)
m.addConstr(4*x0 + 1*x1 + 9*x3 <= 56)
m.addConstr(4*x0 + 1*x1 + 5*x2 <= 128)
m.addConstr(4*x0 + 1*x1 + 5*x2 + 9*x3 <= 128)
m.addConstr(4*x1**2 + 6*x3**2 <= 111)
m.addConstr(4*x0 + 4*x1 <= 125)
m.addConstr(4*x1 + 11*x2 <= 80)
m.addConstr(4*x0**2 + 6*x3**2 <= 95)
m.addConstr(11*x2 + 6*x3 <= 61)
m.addConstr(4*x0 + 11*x2 <= 123)
m.addConstr(4*x0 + 4*x1 + 11*x2 <= 64)
m.addConstr(4*x0 + 11*x2 + 6*x3 <= 86)
m.addConstr(4*x0 + 4*x1 + 11*x2 + 6*x3 <= 86)
m.addConstr(7*x1**2 + 1*x2**2 <= 66)
m.addConstr(7*x0 + 1*x2 <= 48)
m.addConstr(7*x0**2 + 7*x1**2 <= 67)
m.addConstr(1*x2 + 2*x3 <= 24)
m.addConstr(7*x0 + 7*x1 + 1*x2 + 2*x3 <= 24)
m.addConstr(5*x0**2 + 1*x1**2 <= 60)
m.addConstr(5*x0**2 + 10*x2**2 <= 65)
m.addConstr(5*x0 + 1*x1 + 10*x2 + 6*x3 <= 65)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

