
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimize_work_hours")

    # Create variables
    paul_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")
    dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")


    # Set objective function
    m.setObjective(3 * paul_hours + dale_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(14 * paul_hours + 7 * dale_hours >= 77, "combined_likelihood_min")
    m.addConstr(21 * paul_hours + 13 * dale_hours >= 39, "combined_quality_min")
    m.addConstr(9 * paul_hours - 4 * dale_hours >= 0, "paul_dale_ratio")
    m.addConstr(14 * paul_hours + 7 * dale_hours == 130, "combined_likelihood_max")  # Note: equality constraint
    m.addConstr(21 * paul_hours + 13 * dale_hours == 116, "combined_quality_max") # Note: equality constraint


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal solution found:')
        print(f"Paul's hours: {paul_hours.x}")
        print(f"Dale's hours: {dale_hours.x}")
        print(f"Objective value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible.')
    else:
        print(f'Optimization ended with status {m.status}.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
