
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")

# Set the objective function
m.setObjective(3*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 + 7*x2 >= 77, "Total combined likelihood to quit index")
m.addConstr(21*x1 + 13*x2 >= 39, "Total combined work quality rating")
m.addConstr(9*x1 - 4*x2 >= 0, "Constraint on hours worked")
m.addConstr(14*x1 + 7*x2 <= 130, "Upper bound on total likelihood to quit index")
m.addConstr(21*x1 + 13*x2 <= 116, "Upper bound on total work quality rating")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Paul: {x1.x}")
    print(f"Hours worked by Dale: {x2.x}")
else:
    print("No optimal solution found")
