
import gurobi

def solve_optimization_problem():
    try:
        # Create a new model
        model = gurobi.Model()

        # Define variables
        x1 = model.addVar(lb=0, name="hours_worked_by_Paul")
        x2 = model.addVar(lb=0, name="hours_worked_by_Dale")

        # Objective function
        model.setObjective(3*x1 + x2, gurobi.GRB.MAXIMIZE)

        # Constraints
        model.addConstr(x1 >= 1, name="Paul_hours_min")
        model.addConstr(x2 >= 1, name="Dale_hours_min")
        model.addConstr(14*x1 + 7*x2 >= 77, name="quit_index_min")
        model.addConstr(21*x1 + 13*x2 >= 39, name="work_quality_min")
        model.addConstr(9*x1 - 4*x2 >= 0, name="work_balance")
        model.addConstr(14*x1 + 7*x2 <= 130, name="quit_index_max")
        model.addConstr(21*x1 + 13*x2 <= 116, name="work_quality_max")

        # Optimize
        model.optimize()

        # Print solution
        if model.status == gurobi.GRB.OPTIMAL:
            print("Objective: ", model.objVal)
            print("Hours worked by Paul: ", x1.varValue)
            print("Hours worked by Dale: ", x2.varValue)
        else:
            print("No optimal solution found")

    except gurobi.GUROBI_ERROR as e:
        print("Gurobi Error: ", e)

solve_optimization_problem()
