
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B2
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # milligrams of vitamin B3
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of zinc
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # grams of fiber


# Set objective function
m.setObjective(8*x0 + 4*x1 + 8*x2 + 9*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 5*x1 + 6*x2 + 11*x3 <= 195)
m.addConstr(13*x0 + 10*x1 + 12*x2 + 2*x3 <= 270)
m.addConstr(6*x0 + 5*x1 + 11*x2 + 12*x3 <= 168)
m.addConstr(4*x0 + 10*x1 + 8*x2 + 8*x3 <= 207)
m.addConstr(5*x1 + 11*x3 >= 33)
m.addConstr(2*x0 + 6*x2 >= 37)
m.addConstr(6*x2 + 11*x3 >= 45)
m.addConstr(5*x1 + 6*x2 >= 39)
m.addConstr(2*x0 + 6*x2 + 11*x3 >= 39)
m.addConstr(2*x0 + 5*x1 + 11*x3 >= 39)
m.addConstr(2*x0 + 6*x2 + 11*x3 >= 40)
m.addConstr(2*x0 + 5*x1 + 11*x3 >= 40)
m.addConstr(2*x0 + 5*x1 + 6*x2 + 11*x3 >= 40)
m.addConstr(13*x0 + 2*x3 >= 52)
m.addConstr(10*x1 + 2*x3 >= 33)
m.addConstr(12*x2 + 2*x3 >= 45)
m.addConstr(13*x0 + 12*x2 >= 49)
m.addConstr(10*x1 + 12*x2 + 2*x3 >= 49)
m.addConstr(13*x0 + 10*x1 + 12*x2 + 2*x3 >= 49)
m.addConstr(11*x2 + 12*x3 >= 35)
m.addConstr(5*x1 + 11*x2 >= 27)
m.addConstr(6*x0 + 5*x1 + 11*x2 + 12*x3 >= 27)
m.addConstr(4*x0 + 8*x2 >= 37)
m.addConstr(4*x0 + 8*x3 >= 37)
m.addConstr(10*x1 + 8*x2 >= 29)
m.addConstr(8*x2 + 8*x3 >= 35)
m.addConstr(4*x0 + 10*x1 >= 43)
m.addConstr(10*x1 + 8*x3 >= 26)
m.addConstr(10*x1 + 8*x2 + 8*x3 >= 32)
m.addConstr(4*x0 + 10*x1 + 8*x2 >= 32)
m.addConstr(10*x1 + 8*x2 + 8*x3 >= 27)
m.addConstr(4*x0 + 10*x1 + 8*x2 >= 27)
m.addConstr(4*x0 + 10*x1 + 8*x2 + 8*x3 >= 27)
m.addConstr(-8*x2 + 10*x3 >= 0)
m.addConstr(5*x0 - 2*x2 >= 0)
m.addConstr(2*x0 + 5*x1 + 11*x3 <= 105)
m.addConstr(5*x1 + 6*x2 + 11*x3 <= 74)
m.addConstr(2*x0 + 6*x2 + 11*x3 <= 132)
m.addConstr(10*x1 + 2*x3 <= 70)
m.addConstr(10*x1 + 12*x2 <= 169)
m.addConstr(13*x0 + 12*x2 <= 186)
m.addConstr(13*x0 + 12*x2 + 2*x3 <= 238)
m.addConstr(5*x1 + 11*x2 + 12*x3 <= 85)
m.addConstr(6*x0 + 5*x1 + 12*x3 <= 157)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

