
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")
automatic_alerts = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")

# Set objective function
m.setObjective(1.96 * security_onions + 7.17 * intrusion_analysts + 9.92 * honeypots + 6.97 * automatic_alerts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.67 * honeypots + 0.38 * automatic_alerts <= 173, "c0")
m.addConstr(3.78 * security_onions + 1.14 * intrusion_analysts + 5.71 * honeypots + 1.92 * automatic_alerts <= 315, "c1")
m.addConstr(4.56 * security_onions + 0.67 * honeypots + 0.38 * automatic_alerts >= 39, "c2")
m.addConstr(2.96 * intrusion_analysts + 0.67 * honeypots + 0.38 * automatic_alerts >= 39, "c3")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.38 * automatic_alerts >= 39, "c4")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.67 * honeypots >= 39, "c5")
m.addConstr(4.56 * security_onions + 0.67 * honeypots + 0.38 * automatic_alerts >= 27, "c6")
m.addConstr(2.96 * intrusion_analysts + 0.67 * honeypots + 0.38 * automatic_alerts >= 27, "c7")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.38 * automatic_alerts >= 27, "c8")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.67 * honeypots >= 27, "c9")
m.addConstr(4.56 * security_onions + 0.67 * honeypots + 0.38 * automatic_alerts >= 23, "c10")
m.addConstr(2.96 * intrusion_analysts + 0.67 * honeypots + 0.38 * automatic_alerts >= 23, "c11")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.38 * automatic_alerts >= 23, "c12")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.67 * honeypots >= 23, "c13")
m.addConstr(4.56 * security_onions + 0.67 * honeypots + 0.38 * automatic_alerts >= 42, "c14")
m.addConstr(2.96 * intrusion_analysts + 0.67 * honeypots + 0.38 * automatic_alerts >= 42, "c15")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.38 * automatic_alerts >= 42, "c16")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.67 * honeypots >= 42, "c17")
m.addConstr(5.71 * honeypots + 1.92 * automatic_alerts >= 61, "c18")
m.addConstr(3.78 * security_onions + 1.14 * intrusion_analysts >= 62, "c19")
m.addConstr(3.78 * security_onions + 1.92 * automatic_alerts >= 48, "c20")
m.addConstr(0.67 * honeypots + 0.38 * automatic_alerts <= 145, "c21")
m.addConstr(2.96 * intrusion_analysts + 0.38 * automatic_alerts <= 136, "c22")
m.addConstr(2.96 * intrusion_analysts + 0.67 * honeypots <= 169, "c23")
m.addConstr(4.56 * security_onions + 0.38 * automatic_alerts <= 146, "c24")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts <= 104, "c25")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.38 * automatic_alerts <= 167, "c26")
m.addConstr(4.56 * security_onions + 0.67 * honeypots + 0.38 * automatic_alerts <= 114, "c27")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.67 * honeypots <= 68, "c28")
m.addConstr(4.56 * security_onions + 2.96 * intrusion_analysts + 0.67 * honeypots + 0.38 * automatic_alerts <= 68, "c29")
m.addConstr(3.78 * security_onions + 1.92 * automatic_alerts <= 127, "c30")
m.addConstr(1.14 * intrusion_analysts + 5.71 * honeypots <= 84, "c31")
m.addConstr(3.78 * security_onions + 1.14 * intrusion_analysts + 5.71 * honeypots <= 112, "c32")
m.addConstr(3.78 * security_onions + 5.71 * honeypots + 1.92 * automatic_alerts <= 139, "c33")
m.addConstr(3.78 * security_onions + 1.14 * intrusion_analysts + 5.71 * honeypots + 1.92 * automatic_alerts <= 139, "c34")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
