
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b3")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")


# Set objective function
m.setObjective(8.92 * potassium + 6.55 * vitamin_b3 + 4.0 * zinc, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * potassium + 2 * vitamin_b3 + 13 * zinc <= 93, "immune_support_ub")
m.addConstr(7 * potassium + 5 * vitamin_b3 + 10 * zinc <= 146, "digestive_support_ub")
m.addConstr(7 * potassium + 9 * vitamin_b3 + 16 * zinc <= 146, "muscle_growth_ub")
m.addConstr(8 * potassium + 10 * vitamin_b3 + 17 * zinc <= 253, "energy_stability_ub")
m.addConstr(1 * potassium + 12 * vitamin_b3 + 10 * zinc <= 110, "cardiovascular_support_ub")

m.addConstr(15 * potassium + 13 * zinc >= 10, "immune_support_pk_zn_lb")
m.addConstr(2 * vitamin_b3 + 13 * zinc >= 27, "immune_support_vb_zn_lb")
m.addConstr(15 * potassium + 2 * vitamin_b3 + 13 * zinc >= 19, "immune_support_all_lb")

m.addConstr(5 * vitamin_b3 + 10 * zinc >= 43, "digestive_support_vb_zn_lb")
m.addConstr(7 * potassium + 10 * zinc >= 24, "digestive_support_pk_zn_lb")
m.addConstr(7 * potassium + 5 * vitamin_b3 >= 17, "digestive_support_pk_vb_lb")
m.addConstr(7 * potassium + 5 * vitamin_b3 + 10 * zinc >= 17, "digestive_support_all_lb")


m.addConstr(7 * potassium + 9 * vitamin_b3 + 16 * zinc >= 36, "muscle_growth_all_lb")
m.addConstr(7 * potassium + 16 * zinc >= 42, "muscle_growth_pk_zn_lb")
m.addConstr(7 * potassium + 9 * vitamin_b3 >= 30, "muscle_growth_pk_vb_lb")
m.addConstr(9 * vitamin_b3 + 16 * zinc >= 25, "muscle_growth_vb_zn_lb")


m.addConstr(10 * vitamin_b3 + 17 * zinc >= 64, "energy_stability_vb_zn_lb")
m.addConstr(8 * potassium + 10 * vitamin_b3 >= 70, "energy_stability_pk_vb_lb")
m.addConstr(8 * potassium + 17 * zinc >= 56, "energy_stability_pk_zn_lb")
m.addConstr(8 * potassium + 10 * vitamin_b3 + 17 * zinc >= 56, "energy_stability_all_lb")


m.addConstr(1 * potassium + 10 * zinc >= 36, "cardiovascular_support_pk_zn_lb")
m.addConstr(1 * potassium + 12 * vitamin_b3 >= 29, "cardiovascular_support_pk_vb_lb")
m.addConstr(1 * potassium + 12 * vitamin_b3 + 10 * zinc >= 29, "cardiovascular_support_all_lb")

m.addConstr(4 * potassium - 7 * vitamin_b3 >= 0, "custom_constraint")

m.addConstr(15 * potassium + 13 * zinc <= 58, "immune_support_pk_zn_ub")
m.addConstr(15 * potassium + 2 * vitamin_b3 <= 88, "immune_support_pk_vb_ub")
m.addConstr(8 * potassium + 17 * zinc <= 147, "energy_stability_pk_zn_ub")
m.addConstr(8 * potassium + 10 * vitamin_b3 <= 213, "energy_stability_pk_vb_ub")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('potassium:', potassium.x)
    print('vitamin_b3:', vitamin_b3.x)
    print('zinc:', zinc.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

