
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_potassium", lb=0, ub=None)
x2 = model.addVar(name="milligrams_of_vitamin_B3", lb=0, type=gurobi.GRB.INTEGER)
x3 = model.addVar(name="milligrams_of_zinc", lb=0)

# Define the objective function
model.setObjective(8.92 * x1 + 6.55 * x2 + 4.0 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
# Individual index constraints
model.addConstr(15 * x1 <= 93, name="immune_support_index_potassium")
model.addConstr(7 * x1 <= 146, name="digestive_support_index_potassium")
model.addConstr(7 * x1 <= 146, name="muscle_growth_index_potassium")
model.addConstr(8 * x1 <= 253, name="energy_stability_index_potassium")
model.addConstr(x1 <= 110, name="cardiovascular_support_index_potassium")

model.addConstr(2 * x2 <= 93, name="immune_support_index_vitamin_B3")
model.addConstr(5 * x2 <= 146, name="digestive_support_index_vitamin_B3")
model.addConstr(9 * x2 <= 146, name="muscle_growth_index_vitamin_B3")
model.addConstr(10 * x2 <= 253, name="energy_stability_index_vitamin_B3")
model.addConstr(12 * x2 <= 110, name="cardiovascular_support_index_vitamin_B3")

model.addConstr(13 * x3 <= 93, name="immune_support_index_zinc")
model.addConstr(10 * x3 <= 146, name="digestive_support_index_zinc")
model.addConstr(16 * x3 <= 146, name="muscle_growth_index_zinc")
model.addConstr(17 * x3 <= 253, name="energy_stability_index_zinc")
model.addConstr(10 * x3 <= 110, name="cardiovascular_support_index_zinc")

# Combined index constraints
model.addConstr(15 * x1 + 13 * x3 >= 10, name="combined_immune_support_index_potassium_zinc")
model.addConstr(2 * x2 + 13 * x3 >= 27, name="combined_immune_support_index_vitamin_B3_zinc")
model.addConstr(15 * x1 + 2 * x2 + 13 * x3 >= 19, name="combined_immune_support_index_all")

model.addConstr(5 * x2 + 10 * x3 >= 43, name="combined_digestive_support_index_vitamin_B3_zinc")
model.addConstr(7 * x1 + 10 * x3 >= 24, name="combined_digestive_support_index_potassium_zinc")
model.addConstr(7 * x1 + 5 * x2 >= 17, name="combined_digestive_support_index_potassium_vitamin_B3")
model.addConstr(7 * x1 + 5 * x2 + 10 * x3 >= 17, name="combined_digestive_support_index_all")

model.addConstr(7 * x1 + 16 * x3 >= 42, name="combined_muscle_growth_index_potassium_zinc")
model.addConstr(7 * x1 + 9 * x2 >= 30, name="combined_muscle_growth_index_potassium_vitamin_B3")
model.addConstr(9 * x2 + 16 * x3 >= 25, name="combined_muscle_growth_index_vitamin_B3_zinc")
model.addConstr(7 * x1 + 9 * x2 + 16 * x3 >= 36, name="combined_muscle_growth_index_all")

model.addConstr(10 * x2 + 17 * x3 >= 64, name="combined_energy_stability_index_vitamin_B3_zinc")
model.addConstr(8 * x1 + 10 * x2 >= 70, name="combined_energy_stability_index_potassium_vitamin_B3")
model.addConstr(8 * x1 + 17 * x3 >= 56, name="combined_energy_stability_index_potassium_zinc")
model.addConstr(8 * x1 + 10 * x2 + 17 * x3 >= 56, name="combined_energy_stability_index_all")

model.addConstr(x1 + 10 * x3 >= 36, name="combined_cardiovascular_support_index_potassium_zinc")
model.addConstr(x1 + 12 * x2 >= 29, name="combined_cardiovascular_support_index_potassium_vitamin_B3")
model.addConstr(x1 + 12 * x2 + 10 * x3 >= 29, name="combined_cardiovascular_support_index_all")

model.addConstr(4 * x1 - 7 * x2 >= 0, name="constraint_potassium_vitamin_B3")

model.addConstr(15 * x1 + 13 * x3 <= 58, name="upper_bound_combined_immune_support_index_potassium_zinc")
model.addConstr(15 * x1 + 2 * x2 <= 88, name="upper_bound_combined_immune_support_index_potassium_vitamin_B3")

model.addConstr(8 * x1 + 17 * x3 <= 147, name="upper_bound_combined_energy_stability_index_potassium_zinc")
model.addConstr(8 * x1 + 10 * x2 <= 213, name="upper_bound_combined_energy_stability_index_potassium_vitamin_B3")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Milligrams of potassium: ", x1.varValue)
    print("Milligrams of vitamin B3: ", x2.varValue)
    print("Milligrams of zinc: ", x3.varValue)
else:
    print("The model is infeasible")
