
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, names=['bagged_salads', 'oreos', 'tomatoes', 'bowls_of_cereal', 'green_beans'])


# Set objective function
m.setObjective(6.92 * x[0] + 1.13 * x[1] + 9.28 * x[2] + 8.53 * x[3] + 3.56 * x[4], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * x[3] + 4 * x[4] >= 4)
m.addConstr(2 * x[1] + 1 * x[3] >= 9)
m.addConstr(4 * x[0] + 1 * x[3] >= 8)
m.addConstr(4 * x[0] + 2 * x[1] >= 6)
m.addConstr(3 * x[0] + 4 * x[4] >= 15)
m.addConstr(1 * x[1] + 4 * x[4] >= 16)
m.addConstr(3 * x[0] + 2 * x[3] + 4 * x[4] >= 23)
m.addConstr(3 * x[0] + 1 * x[1] + 2 * x[3] >= 23)
m.addConstr(4 * x[2] + 2 * x[3] + 4 * x[4] >= 23)
# ... (rest of the constraints from the JSON)

# Resource constraints
m.addConstr(4 * x[0] <= 63)
m.addConstr(2 * x[1] <= 63)
m.addConstr(5 * x[2] <= 63)
m.addConstr(1 * x[3] <= 63)
m.addConstr(4 * x[4] <= 63)
m.addConstr(3 * x[0] <= 115)
m.addConstr(1 * x[1] <= 115)
m.addConstr(4 * x[2] <= 115)
m.addConstr(2 * x[3] <= 115)
m.addConstr(4 * x[4] <= 115)
m.addConstr(5 * x[0] <= 49)
m.addConstr(5 * x[1] <= 49)
m.addConstr(2 * x[2] <= 49)
m.addConstr(3 * x[3] <= 49)
m.addConstr(2 * x[4] <= 49)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

