
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x = m.addVars(6, lb=0, vtype=[gp.GRB.CONTINUOUS, gp.GRB.CONTINUOUS, gp.GRB.INTEGER, gp.GRB.INTEGER, gp.GRB.CONTINUOUS, gp.GRB.INTEGER], name=["Hank", "Paul", "Mary", "Ringo", "Jean", "John"])


    # Set objective function
    m.setObjective(1.73 * x[0] + 1.02 * x[1] + 2.71 * x[2] + 3.81 * x[3] + 9.75 * x[4] + 3.15 * x[5], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(17 * x[1] + 8 * x[3] >= 32)
    m.addConstr(5 * x[0] + 17 * x[1] >= 22)
    m.addConstr(8 * x[3] + 7 * x[4] >= 18)
    m.addConstr(5 * x[0] + 8 * x[3] >= 19)
    m.addConstr(17 * x[1] + 1 * x[2] >= 13)
    m.addConstr(7 * x[4] + 5 * x[5] >= 29)
    m.addConstr(1 * x[2] + 5 * x[5] >= 31)
    m.addConstr(17 * x[1] + 5 * x[5] >= 10)
    m.addConstr(5 * x[0] + 5 * x[5] >= 13)
    m.addConstr(5 * x[0] + 7 * x[4] >= 12)
    m.addConstr(8 * x[3] + 5 * x[5] >= 29)
    m.addConstr(5 * x[0] + 17 * x[1] + 1 * x[2] + 8 * x[3] + 7 * x[4] + 5 * x[5] >= 29)
    m.addConstr(12 * x[2] + 14 * x[5] >= 16)
    m.addConstr(12 * x[2] + 8 * x[3] >= 27)
    m.addConstr(19 * x[0] + 18 * x[1] + 12 * x[2] + 8 * x[3] + 17 * x[4] + 14 * x[5] >= 27)
    m.addConstr(2 * x[1] - 3 * x[4] >= 0)
    m.addConstr(8 * x[0] - 2 * x[4] >= 0)
    m.addConstr(6 * x[1] - 3 * x[5] >= 0)
    m.addConstr(17 * x[1] + 1 * x[2] <= 122)
    m.addConstr(5 * x[0] + 1 * x[2] <= 149)
    m.addConstr(5 * x[0] + 7 * x[4] <= 110)
    m.addConstr(17 * x[1] + 8 * x[3] <= 36)
    m.addConstr(8 * x[3] + 5 * x[5] <= 84)
    m.addConstr(1 * x[2] + 5 * x[5] <= 37)
    m.addConstr(17 * x[1] + 5 * x[5] <= 72)
    m.addConstr(8 * x[3] + 7 * x[4] <= 38)
    m.addConstr(18 * x[1] + 12 * x[2] + 17 * x[4] <= 69)
    m.addConstr(18 * x[1] + 17 * x[4] + 14 * x[5] <= 81)
    m.addConstr(19 * x[0] + 17 * x[4] + 14 * x[5] <= 83)
    m.addConstr(19 * x[0] + 18 * x[1] + 17 * x[4] <= 200)
    m.addConstr(19 * x[0] + 18 * x[1] + 8 * x[3] <= 45)
    m.addConstr(19 * x[0] + 12 * x[2] + 17 * x[4] <= 59)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
