
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0, ub=None, vtype=gp.GRB.CONTINUOUS)  # hours worked by Hank
x1 = m.addVar(name="x1", lb=0, ub=None, vtype=gp.GRB.CONTINUOUS)  # hours worked by Paul
x2 = m.addVar(name="x2", lb=0, ub=None, vtype=gp.GRB.INTEGER)    # hours worked by Mary
x3 = m.addVar(name="x3", lb=0, ub=None, vtype=gp.GRB.INTEGER)    # hours worked by Ringo
x4 = m.addVar(name="x4", lb=0, ub=None, vtype=gp.GRB.CONTINUOUS) # hours worked by Jean
x5 = m.addVar(name="x5", lb=0, ub=None, vtype=gp.GRB.INTEGER)    # hours worked by John

# Define the objective function
m.setObjective(1.73*x0 + 1.02*x1 + 2.71*x2 + 3.81*x3 + 9.75*x4 + 3.15*x5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x1 + 8*x3 >= 32)
m.addConstr(5*x0 + 17*x1 >= 22)
m.addConstr(8*x3 + 7*x4 >= 18)
m.addConstr(5*x0 + 8*x3 >= 19)
m.addConstr(17*x1 + x2 >= 13)
m.addConstr(7*x4 + 5*x5 >= 29)
m.addConstr(x2 + 14*x5 >= 31)
m.addConstr(17*x1 + 5*x5 >= 10)
m.addConstr(5*x0 + 5*x5 >= 13)
m.addConstr(5*x0 + 7*x4 >= 12)
m.addConstr(8*x3 + 5*x5 >= 29)
m.addConstr(5*x0 + 17*x1 + x2 + 8*x3 + 7*x4 + 5*x5 >= 29)
m.addConstr(12*x2 + 14*x5 >= 16)
m.addConstr(12*x2 + 8*x3 >= 27)
m.addConstr(19*x0 + 18*x1 + 12*x2 + 8*x3 + 17*x4 + 14*x5 >= 27)
m.addConstr(2*x1 - 3*x4 >= 0)
m.addConstr(8*x0 - 2*x4 >= 0)
m.addConstr(6*x1 - 3*x5 >= 0)
m.addConstr(17*x1 + x2 <= 122)
m.addConstr(5*x0 + x2 <= 149)
m.addConstr(5*x0 + 7*x4 <= 110)
m.addConstr(17*x1 + 8*x3 <= 36)
m.addConstr(8*x3 + 5*x5 <= 84)
m.addConstr(x2 + 5*x5 <= 37)
m.addConstr(17*x1 + 5*x5 <= 72)
m.addConstr(8*x3 + 7*x4 <= 38)
m.addConstr(18*x1 + 12*x2 + 17*x4 <= 69)
m.addConstr(18*x1 + 17*x4 + 14*x5 <= 81)
m.addConstr(19*x0 + 17*x4 + 14*x5 <= 83)
m.addConstr(19*x0 + 18*x1 + 17*x4 <= 200)
m.addConstr(19*x0 + 18*x1 + 8*x3 <= 45)
m.addConstr(19*x0 + 12*x2 + 17*x4 <= 59)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("No optimal solution found")
