
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")
x2 = m.addVar(vtype=GRB.INTEGER, name="rubber_bands")
x3 = m.addVar(vtype=GRB.INTEGER, name="headsets")

# Set the objective function
m.setObjective(9*x1 + 8*x2 + 6*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(17*x1 + 16*x2 >= 52, "usefulness_coffee_rubber")
m.addConstr(16*x2 + 13*x3 >= 30, "usefulness_rubber_headsets")
m.addConstr(17*x1 + 16*x2 + 13*x3 >= 40, "total_usefulness_min")
m.addConstr(6*x1 - 2*x3 >= 0, "coffee_headsets_constraint")
m.addConstr(16*x2 + 13*x3 <= 157, "max_rubber_headsets")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cans of Coffee: {x1.x}")
    print(f"Rubber Bands: {x2.x}")
    print(f"Headsets: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
