
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="cans_of_coffee", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="rubber_bands", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="headsets", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9*x1 + 8*x2 + 6*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17*x1 + 16*x2 >= 52, name="constraint_1")
    model.addConstr(16*x2 + 13*x3 >= 30, name="constraint_2")
    model.addConstr(17*x1 + 16*x2 + 13*x3 >= 40, name="constraint_3")
    model.addConstr(6*x1 - 2*x3 >= 0, name="constraint_4")
    model.addConstr(16*x2 + 13*x3 <= 157, name="constraint_5")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cans of coffee: {x1.varValue}")
        print(f"Rubber bands: {x2.varValue}")
        print(f"Headsets: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
