
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x4")


# Set objective function
m.setObjective(1.84*x0**2 + 7.25*x0*x1 + 2.77*x0*x3 + 8.72*x1**2 + 7.42*x1*x3 + 2.54*x1*x4 + 9.88*x2**2 + 5.3*x2*x4 + 3.67*x3**2 + 3.94*x3*x4 + 8.96*x4**2 + 7.01*x2 + 6.55*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 10*x4 >= 42)
m.addConstr(15*x1 + 16*x2 >= 32)
m.addConstr(16*x2**2 + 11*x3**2 >= 24)
m.addConstr(16*x2 + 10*x4 >= 47)
m.addConstr(15*x1**2 + 11*x3**2 >= 21)
m.addConstr(19*x0 + 11*x3 >= 23)
m.addConstr(19*x0**2 + 15*x1**2 + 16*x2**2 >= 30)
m.addConstr(15*x1 + 16*x2 + 11*x3 >= 30)
m.addConstr(16*x2 + 11*x3 + 10*x4 >= 30)
m.addConstr(19*x0 + 15*x1 + 16*x2 >= 23)
m.addConstr(15*x1**2 + 16*x2**2 + 11*x3**2 >= 23)
m.addConstr(16*x2 + 11*x3 + 10*x4 >= 23)
m.addConstr(19*x0 + 15*x1 + 16*x2 >= 42)
m.addConstr(15*x1 + 16*x2 + 11*x3 >= 42)
m.addConstr(16*x2 + 11*x3 + 10*x4 >= 42)
m.addConstr(6*x0 - 10*x4 >= 0)
m.addConstr(11*x3 + 10*x4 <= 218)
m.addConstr(19*x0 + 15*x1 <= 189)
m.addConstr(15*x1**2 + 16*x2**2 + 10*x4**2 <= 190)
m.addConstr(16*x2**2 + 11*x3**2 + 10*x4**2 <= 140)
m.addConstr(15*x1 + 11*x3 + 10*x4 <= 118)
m.addConstr(19*x0**2 + 15*x1**2 + 16*x2**2 <= 151)
m.addConstr(15*x1 + 16*x2 + 11*x3 <= 95)
m.addConstr(19*x0 + 15*x1 + 16*x2 + 11*x3 + 10*x4 <= 95)
m.addConstr(19*x0 + 15*x1 + 16*x2 + 11*x3 + 10*x4 <= 237)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

