
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="x1", lb=-gp.GRB.INFINITY)  # milligrams of vitamin A
x2 = m.addVar(name="x2", lb=-gp.GRB.INFINITY)  # milligrams of vitamin B5
x3 = m.addVar(name="x3", lb=-gp.GRB.INFINITY)  # milligrams of iron
x4 = m.addVar(name="x4", lb=-gp.GRB.INFINITY)  # milligrams of vitamin B3
x5 = m.addVar(name="x5", lb=-gp.GRB.INFINITY)  # grams of carbohydrates

# Define the objective function
m.setObjective(1.84*x1**2 + 7.25*x1*x2 + 2.77*x1*x4 + 8.72*x2**2 + 7.42*x2*x4 + 2.54*x2*x5 + 
               9.88*x3**2 + 5.3*x3*x5 + 3.67*x4**2 + 3.94*x4*x5 + 8.96*x5**2 + 7.01*x3 + 6.55*x5, 
               sense=gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(19*x1 <= 237)
m.addConstr(15*x2 <= 237)
m.addConstr(16*x3 <= 237)
m.addConstr(11*x4 <= 237)
m.addConstr(10*x5 <= 237)

m.addConstr(15*x2 + 10*x5 >= 42)
m.addConstr(15*x2 + 16*x3 >= 32)
m.addConstr(16*x3**2 + 11*x4**2 >= 24)
m.addConstr(16*x3 + 10*x5 >= 47)
m.addConstr(15*x2**2 + 11*x4**2 >= 21)
m.addConstr(19*x1 + 11*x4 >= 23)
m.addConstr(19*x1**2 + 15*x2**2 + 16*x3**2 >= 30)
m.addConstr(15*x2 + 16*x3 + 11*x4 >= 30)
m.addConstr(16*x3 + 11*x4 + 10*x5 >= 30)
m.addConstr(19*x1 + 15*x2 + 16*x3 >= 23)
m.addConstr(15*x2**2 + 16*x3**2 + 11*x4**2 >= 23)
m.addConstr(16*x3 + 11*x4 + 10*x5 >= 23)
m.addConstr(19*x1 + 15*x2 + 16*x3 >= 42)
m.addConstr(15*x2 + 16*x3 + 11*x4 >= 42)
m.addConstr(16*x3 + 11*x4 + 10*x5 >= 42)
m.addConstr(6*x1 - 10*x5 >= 0)
m.addConstr(11*x4 + 10*x5 <= 218)
m.addConstr(19*x1 + 15*x2 <= 189)
m.addConstr(15*x2**2 + 16*x3**2 + 10*x5**2 <= 190)
m.addConstr(16*x3**2 + 11*x4**2 + 10*x5**2 <= 140)
m.addConstr(15*x2 + 11*x4 + 10*x5 <= 118)
m.addConstr(19*x1**2 + 15*x2**2 + 16*x3**2 <= 151)
m.addConstr(15*x2 + 16*x3 + 11*x4 <= 95)
m.addConstr(19*x1 + 15*x2 + 16*x3 + 11*x4 + 10*x5 <= 95)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Objective value:", m.objVal)
    print("x1:", x1.varValue)
    print("x2:", x2.varValue)
    print("x3:", x3.varValue)
    print("x4:", x4.varValue)
    print("x5:", x5.varValue)
else:
    print("No optimal solution found.")
