
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
network_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
automatic_alerts = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")


# Set objective function
m.setObjective(8.9 * network_administrators + 9.67 * pen_testers + 9.63 * automatic_alerts + 9.12 * honeypots, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * network_administrators + 7 * pen_testers + 7 * automatic_alerts + 8 * honeypots <= 94, "r0")
m.addConstr(6 * network_administrators + 5 * pen_testers + 2 * automatic_alerts + 6 * honeypots <= 70, "r1")
m.addConstr(7 * network_administrators + 4 * pen_testers + 2 * automatic_alerts + 1 * honeypots <= 89, "r2")
m.addConstr(2 * network_administrators + 4 * pen_testers + 6 * automatic_alerts + 5 * honeypots <= 39, "r3")
m.addConstr(7 * pen_testers + 8 * honeypots >= 17, "c5")
m.addConstr(7 * pen_testers + 7 * automatic_alerts >= 13, "c6")
m.addConstr(8 * network_administrators + 7 * automatic_alerts >= 9, "c7")
m.addConstr(2 * automatic_alerts + 6 * honeypots >= 17, "c8")
m.addConstr(6 * network_administrators + 5 * pen_testers >= 13, "c9")
m.addConstr(6 * network_administrators + 5 * pen_testers + 6 * honeypots >= 10, "c10")
m.addConstr(4 * pen_testers + 2 * automatic_alerts >= 8, "c11")
m.addConstr(4 * pen_testers + 1 * honeypots >= 16, "c12")
m.addConstr(2 * network_administrators + 6 * automatic_alerts >= 7, "c13")
m.addConstr(4 * pen_testers + 6 * automatic_alerts >= 9, "c14")
m.addConstr(2 * network_administrators + 5 * honeypots >= 4, "c15")
m.addConstr(4 * pen_testers + 5 * honeypots >= 6, "c16")
m.addConstr(2 * pen_testers - 10 * automatic_alerts + 3 * honeypots >= 0, "c17")
m.addConstr(7 * pen_testers + 8 * honeypots <= 35, "c18")
m.addConstr(8 * network_administrators + 8 * honeypots <= 71, "c19")
m.addConstr(7 * automatic_alerts + 8 * honeypots <= 49, "c20")
m.addConstr(8 * network_administrators + 7 * pen_testers + 7 * automatic_alerts + 8 * honeypots <= 49, "c21")
m.addConstr(2 * automatic_alerts + 6 * honeypots <= 40, "c22")
m.addConstr(6 * network_administrators + 6 * honeypots <= 18, "c23")
m.addConstr(5 * pen_testers + 6 * honeypots <= 41, "c24")
m.addConstr(6 * network_administrators + 5 * pen_testers <= 69, "c25")
m.addConstr(5 * pen_testers + 2 * automatic_alerts + 6 * honeypots <= 52, "c26")
m.addConstr(6 * network_administrators + 5 * pen_testers + 2 * automatic_alerts + 6 * honeypots <= 52, "c27")
m.addConstr(4 * pen_testers + 1 * honeypots <= 86, "c28")
m.addConstr(4 * pen_testers + 2 * automatic_alerts <= 31, "c29")
m.addConstr(2 * automatic_alerts + 1 * honeypots <= 23, "c30")
m.addConstr(7 * network_administrators + 4 * pen_testers + 2 * automatic_alerts <= 51, "c31")
m.addConstr(4 * pen_testers + 2 * automatic_alerts + 1 * honeypots <= 63, "c32")
m.addConstr(7 * network_administrators + 4 * pen_testers + 1 * honeypots <= 67, "c33")
m.addConstr(7 * network_administrators + 4 * pen_testers + 2 * automatic_alerts + 1 * honeypots <= 67, "c34")
m.addConstr(4 * pen_testers + 6 * automatic_alerts <= 39, "c35")
m.addConstr(2 * network_administrators + 4 * pen_testers <= 37, "c36")
m.addConstr(4 * pen_testers + 5 * honeypots <= 21, "c37")
m.addConstr(2 * network_administrators + 4 * pen_testers + 6 * automatic_alerts <= 30, "c38")
m.addConstr(2 * network_administrators + 6 * automatic_alerts + 5 * honeypots <= 19, "c39")
m.addConstr(2 * network_administrators + 4 * pen_testers + 5 * honeypots <= 31, "c40")
m.addConstr(2 * network_administrators + 4 * pen_testers + 6 * automatic_alerts + 5 * honeypots <= 31, "c41")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

