
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
    vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
    vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")


    # Set objective function
    m.setObjective(7*zinc + 5*vitamin_b2 + 4*vitamin_b4 + 7*vitamin_c, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1*zinc + 25*vitamin_b2 >= 47)
    m.addConstr(10*vitamin_b4 + 16*vitamin_c >= 44)
    m.addConstr(1*zinc + 16*vitamin_c >= 32)
    m.addConstr(1*zinc + 25*vitamin_b2 + 16*vitamin_c >= 38)
    m.addConstr(1*zinc + 25*vitamin_b2 + 10*vitamin_b4 + 16*vitamin_c >= 38)
    m.addConstr(15*vitamin_b2 + 8*vitamin_b4 >= 18)
    m.addConstr(21*zinc + 8*vitamin_b4 >= 21)
    m.addConstr(8*vitamin_b4 + 17*vitamin_c >= 21)
    m.addConstr(21*zinc + 15*vitamin_b2 >= 25)
    m.addConstr(21*zinc + 15*vitamin_b2 + 8*vitamin_b4 + 17*vitamin_c >= 25)
    m.addConstr(9*vitamin_b2 - 6*vitamin_b4 >= 0)
    m.addConstr(10*zinc - 3*vitamin_b2 >= 0)
    m.addConstr(1*zinc + 25*vitamin_b2 <= 165)
    m.addConstr(25*vitamin_b2 + 10*vitamin_b4 <= 79)
    m.addConstr(1*zinc + 10*vitamin_b4 <= 224)
    m.addConstr(15*vitamin_b2 + 8*vitamin_b4 + 17*vitamin_c <= 113)
    m.addConstr(21*zinc + 15*vitamin_b2 + 8*vitamin_b4 <= 126)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
