
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(lb=0, name="milligrams of zinc")
x1 = model.addVar(lb=0, name="milligrams of vitamin B2")
x2 = model.addVar(lb=0, name="milligrams of vitamin B4")
x3 = model.addVar(lb=0, name="milligrams of vitamin C")

# Objective function
model.setObjective(7 * x0 + 5 * x1 + 4 * x2 + 7 * x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(x0 + 25 * x1 >= 47)
model.addConstr(10 * x2 + 16 * x3 >= 44)
model.addConstr(x0 + 16 * x3 >= 32)
model.addConstr(x0 + 25 * x1 + 16 * x3 >= 38)
model.addConstr(x0 + 25 * x1 + 10 * x2 + 16 * x3 >= 38)
model.addConstr(15 * x1 + 8 * x2 >= 18)
model.addConstr(21 * x0 + 8 * x2 >= 21)
model.addConstr(8 * x2 + 17 * x3 >= 21)
model.addConstr(21 * x0 + 15 * x1 >= 25)
model.addConstr(21 * x0 + 15 * x1 + 8 * x2 + 17 * x3 >= 25)
model.addConstr(9 * x1 - 6 * x2 >= 0)
model.addConstr(10 * x0 - 3 * x1 >= 0)
model.addConstr(x0 + 25 * x1 <= 165)
model.addConstr(25 * x1 + 10 * x2 <= 79)
model.addConstr(x0 + 10 * x2 <= 224)
model.addConstr(15 * x1 + 8 * x2 + 17 * x3 <= 113)
model.addConstr(21 * x0 + 15 * x1 + 8 * x2 <= 126)
model.addConstr(x0 + 25 * x1 + 10 * x2 + 16 * x3 <= 244)
model.addConstr(21 * x0 + 15 * x1 + 8 * x2 + 17 * x3 <= 156)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("x0: ", x0.x)
    print("x1: ", x1.x)
    print("x2: ", x2.x)
    print("x3: ", x3.x)
else:
    print("The model is infeasible")
