
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_a = m.addVar(vtype=GRB.INTEGER, name="vitamin_a")
    vitamin_b12 = m.addVar(vtype=GRB.INTEGER, name="vitamin_b12")
    calcium = m.addVar(vtype=GRB.CONTINUOUS, name="calcium")


    # Set objective function
    m.setObjective(5.95 * vitamin_a + 6.95 * vitamin_b12 + 1.06 * calcium, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6 * vitamin_a + 2 * calcium >= 8, "c1")
    m.addConstr(6 * vitamin_a + 3 * vitamin_b12 >= 16, "c2")
    m.addConstr(6 * vitamin_a + 3 * vitamin_b12 + 2 * calcium >= 16, "c3")
    m.addConstr(-5 * vitamin_a + 9 * calcium >= 0, "c4")
    m.addConstr(6 * vitamin_a + 3 * vitamin_b12 + 2 * calcium <= 31, "c5")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_a:', vitamin_a.x)
        print('vitamin_b12:', vitamin_b12.x)
        print('calcium:', calcium.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

