
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='milligrams_of_vitamin_A', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='milligrams_of_vitamin_B12', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='milligrams_of_calcium')

    # Set the objective function
    model.setObjective(5.95 * x1 + 6.95 * x2 + 1.06 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x1 <= 49)
    model.addConstr(3 * x2 <= 49)
    model.addConstr(2 * x3 <= 49)
    model.addConstr(6 * x1 + 2 * x3 >= 8)
    model.addConstr(6 * x1 + 3 * x2 >= 16)
    model.addConstr(6 * x1 + 3 * x2 + 2 * x3 >= 16)
    model.addConstr(-5 * x1 + 9 * x3 >= 0)
    model.addConstr(6 * x1 + 3 * x2 + 2 * x3 <= 31)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'milligrams of vitamin A: {x1.varValue}')
        print(f'milligrams of vitamin B12: {x2.varValue}')
        print(f'milligrams of calcium: {x3.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
