
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
laura_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura_hours")
peggy_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy_hours")
dale_hours = m.addVar(lb=0, vtype=GRB.INTEGER, name="dale_hours")


# Set objective function
m.setObjective(1*laura_hours**2 + 6*peggy_hours**2 + 3*dale_hours**2 + 8*peggy_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*laura_hours + 5*peggy_hours + 1*dale_hours <= 24, "computer_competence_total")
m.addConstr(8*laura_hours + 7*peggy_hours + 1*dale_hours <= 59, "organization_score_total")
m.addConstr(5*peggy_hours + 1*dale_hours <= 23, "computer_competence_peggy_dale")
m.addConstr(3*laura_hours + 5*peggy_hours <= 24, "computer_competence_laura_peggy")
m.addConstr(8*laura_hours + 1*dale_hours <= 23, "organization_score_laura_dale")
m.addConstr(8*laura_hours + 7*peggy_hours <= 59, "organization_score_laura_peggy")

m.addConstr(8*laura_hours**2 + 7*peggy_hours**2 + 1*dale_hours**2 >= 18, "organization_score_squared")
m.addConstr(-10*laura_hours + 3*dale_hours >= 0, "laura_dale_relation")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Laura Hours: %g' % laura_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

