
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Laura
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Peggy
    x2 = model.addVar(name="x2", lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Dale

    # Objective function
    model.setObjective(1 * x0**2 + 6 * x1**2 + 3 * x2**2 + 8 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0**2 + x1**2 + x2**2 >= 18)
    model.addConstr(-10 * x0 + 3 * x2 >= 0)
    model.addConstr(5 * x1 + x2 <= 23)
    model.addConstr(3 * x0 + 5 * x1 <= 24)
    model.addConstr(3 * x0 + 5 * x1 + x2 <= 24)
    model.addConstr(8 * x0 + x2 <= 23)
    model.addConstr(7 * x1 + x2 <= 23)
    model.addConstr(8 * x0 + 7 * x1 + x2 <= 59)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Peggy: ", x1.varValue)
        print("Hours worked by Dale: ", x2.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
