
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = {}
    x[0] = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cornichons")
    x[1] = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
    x[2] = m.addVar(vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")
    x[3] = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
    x[4] = m.addVar(vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")


    # Set objective function
    m.setObjective(2.02*x[0] + 2.38*x[1] + 1.8*x[2] + 4.35*x[3] + 5.67*x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8*x[0] + 7*x[1] + 25*x[2] + 20*x[3] + 26*x[4] <= 376, "tastiness_rating")
    m.addConstr(25*x[2] + 26*x[4] >= 28, "c1")
    m.addConstr(8*x[0] + 7*x[1] + 20*x[3] >= 74, "c2")
    m.addConstr(8*x[0] + 25*x[2] + 20*x[3] >= 74, "c3")
    m.addConstr(8*x[0] + 20*x[3] + 26*x[4] >= 74, "c4")
    m.addConstr(25*x[2] + 20*x[3] + 26*x[4] >= 74, "c5")
    m.addConstr(8*x[0] + 7*x[1] + 20*x[3] >= 69, "c6")
    m.addConstr(8*x[0] + 25*x[2] + 20*x[3] >= 69, "c7")
    m.addConstr(8*x[0] + 20*x[3] + 26*x[4] >= 69, "c8")
    m.addConstr(25*x[2] + 20*x[3] + 26*x[4] >= 69, "c9")
    m.addConstr(8*x[0] + 7*x[1] + 20*x[3] >= 75, "c10")
    m.addConstr(8*x[0] + 25*x[2] + 20*x[3] >= 75, "c11")
    m.addConstr(8*x[0] + 20*x[3] + 26*x[4] >= 75, "c12")
    m.addConstr(25*x[2] + 20*x[3] + 26*x[4] >= 75, "c13")
    m.addConstr(8*x[0] + 7*x[1] + 20*x[3] >= 61, "c14")
    m.addConstr(8*x[0] + 25*x[2] + 20*x[3] >= 61, "c15")
    m.addConstr(8*x[0] + 20*x[3] + 26*x[4] >= 61, "c16")
    m.addConstr(25*x[2] + 20*x[3] + 26*x[4] >= 61, "c17")
    m.addConstr(-7*x[2] + 2*x[3] + 8*x[4] >= 0, "c18")
    m.addConstr(8*x[0] + 7*x[1] <= 241, "c19")
    m.addConstr(8*x[0] + 20*x[3] <= 352, "c20")
    m.addConstr(25*x[2] + 20*x[3] <= 278, "c21")
    m.addConstr(8*x[0] + 25*x[2] + 20*x[3] <= 188, "c22")
    m.addConstr(7*x[1] + 25*x[2] + 20*x[3] <= 336, "c23")
    m.addConstr(8*x[0] + 7*x[1] + 25*x[2] + 20*x[3] + 26*x[4] <= 336, "c24")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
