
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="cornichons", lb=0)  # No lower bound specified, assuming 0
x2 = model.addVar(name="fruit_salads", lb=0)  # No lower bound specified, assuming 0
x3 = model.addVar(name="slices_of_pizza", lb=0)  # No lower bound specified, assuming 0
x4 = model.addVar(name="cherry_pies", lb=0)  # No lower bound specified, assuming 0
x5 = model.addVar(name="blueberry_pies", lb=0)  # No lower bound specified, assuming 0

# Objective function
model.setObjective(2.02 * x1 + 2.38 * x2 + 1.8 * x3 + 4.35 * x4 + 5.67 * x5, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(8 * x1 <= 376)
model.addConstr(7 * x2 <= 376)
model.addConstr(25 * x3 <= 376)
model.addConstr(20 * x4 <= 376)
model.addConstr(26 * x5 <= 376)

model.addConstr(25 * x3 + 26 * x5 >= 28)
model.addConstr(8 * x1 + 7 * x2 + 20 * x4 >= 74)
model.addConstr(8 * x1 + 25 * x3 + 20 * x4 >= 74)
model.addConstr(8 * x1 + 20 * x4 + 26 * x5 >= 74)
model.addConstr(25 * x3 + 20 * x4 + 26 * x5 >= 74)

model.addConstr(8 * x1 + 7 * x2 + 20 * x4 >= 69)
model.addConstr(8 * x1 + 25 * x3 + 20 * x4 >= 69)
model.addConstr(8 * x1 + 20 * x4 + 26 * x5 >= 69)
model.addConstr(25 * x3 + 20 * x4 + 26 * x5 >= 69)

model.addConstr(8 * x1 + 7 * x2 + 20 * x4 >= 75)
model.addConstr(8 * x1 + 25 * x3 + 20 * x4 >= 75)
model.addConstr(8 * x1 + 20 * x4 + 26 * x5 >= 75)
model.addConstr(25 * x3 + 20 * x4 + 26 * x5 >= 75)

model.addConstr(8 * x1 + 7 * x2 + 20 * x4 >= 61)
model.addConstr(8 * x1 + 25 * x3 + 20 * x4 >= 61)
model.addConstr(8 * x1 + 20 * x4 + 26 * x5 >= 61)
model.addConstr(25 * x3 + 20 * x4 + 26 * x5 >= 61)

model.addConstr(-7 * x3 + 2 * x4 + 8 * x5 >= 0)

model.addConstr(8 * x1 + 7 * x2 <= 241)
model.addConstr(8 * x1 + 20 * x4 <= 352)
model.addConstr(25 * x3 + 20 * x4 <= 278)
model.addConstr(8 * x1 + 25 * x3 + 20 * x4 <= 188)
model.addConstr(7 * x2 + 25 * x3 + 20 * x4 <= 336)
model.addConstr(8 * x1 + 7 * x2 + 25 * x3 + 20 * x4 + 26 * x5 <= 336)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("cornichons: ", x1.varValue)
    print("fruit_salads: ", x2.varValue)
    print("slices_of_pizza: ", x3.varValue)
    print("cherry_pies: ", x4.varValue)
    print("blueberry_pies: ", x5.varValue)
else:
    print("No optimal solution found")
