
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    vincas = m.addVar(vtype=gp.GRB.INTEGER, name="vincas")
    tomato_vines = m.addVar(vtype=gp.GRB.INTEGER, name="tomato_vines")
    strawberry_bushes = m.addVar(vtype=gp.GRB.INTEGER, name="strawberry_bushes")
    ferns = m.addVar(vtype=gp.GRB.INTEGER, name="ferns")

    # Set objective function
    m.setObjective(4*vincas**2 + 9*vincas*tomato_vines + 9*vincas*strawberry_bushes + 4*vincas*ferns + 9*tomato_vines*strawberry_bushes + 6*strawberry_bushes**2 + 6*strawberry_bushes*ferns + 4*ferns**2 + 2*tomato_vines, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*vincas + 1*tomato_vines + 10*strawberry_bushes + 9*ferns <= 92)
    m.addConstr(2*vincas + 9*ferns >= 12)
    m.addConstr(2*vincas**2 + 10*strawberry_bushes**2 >= 22)
    m.addConstr(1*tomato_vines + 10*strawberry_bushes >= 9)
    m.addConstr(2*vincas + 1*tomato_vines >= 11)
    m.addConstr(10*strawberry_bushes**2 + 9*ferns**2 >= 14)
    m.addConstr(2*vincas**2 + 10*strawberry_bushes**2 + 9*ferns**2 >= 17)
    m.addConstr(2*vincas**2 + 1*tomato_vines**2 + 10*strawberry_bushes**2 >= 17)
    m.addConstr(2*vincas + 10*strawberry_bushes + 9*ferns >= 12)
    m.addConstr(2*vincas**2 + 1*tomato_vines**2 + 10*strawberry_bushes**2 >= 12)
    m.addConstr(2*vincas + 10*strawberry_bushes <= 58)
    m.addConstr(2*vincas**2 + 1*tomato_vines**2 <= 49)
    m.addConstr(1*tomato_vines + 10*strawberry_bushes <= 27)
    m.addConstr(10*strawberry_bushes**2 + 9*ferns**2 <= 82)
    m.addConstr(2*vincas + 9*ferns <= 36)
    m.addConstr(1*tomato_vines + 9*ferns <= 69)
    m.addConstr(2*vincas + 1*tomato_vines + 10*strawberry_bushes + 9*ferns <= 69)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
