
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="protein_bars")  # protein bars
    x1 = m.addVar(name="hot_dogs")  # hot dogs


    # Set objective function
    m.setObjective(5*x0**2 + 7*x1**2 + x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16*x0**2 + 16*x1**2 >= 26, "fiber_constraint1")
    m.addConstr(16*x0 + 16*x1 >= 26, "fiber_constraint2")
    m.addConstr(11*x0**2 + 1*x1**2 >= 38, "tastiness_constraint1")
    m.addConstr(11*x0 + 1*x1 >= 38, "tastiness_constraint2")
    m.addConstr(15*x0 + 15*x1 >= 27, "umami_constraint1")
    m.addConstr(x0 - 9*x1 >= 0, "constraint6")
    m.addConstr(16*x0 + 16*x1 <= 66, "fiber_constraint3")
    m.addConstr(11*x0 + 1*x1 <= 66, "tastiness_constraint3")
    m.addConstr(15*x0 + 15*x1 <= 75, "umami_constraint2")



    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal solution found:")
        for v in m.getVars():
            print(f"{v.varName}: {v.x}")
        print(f"Objective value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model was built correctly.")

