
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="protein_bars", lb=0)  # No upper bound given
x2 = model.addVar(name="hot_dogs", lb=0)    # No upper bound given

# Define the objective function
model.setObjective(5*x1**2 + 7*x2**2 + x2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(16*x1**2 + 16*x2**2 >= 26, name="fiber_squared")
model.addConstr(16*x1 + 16*x2 >= 26, name="fiber_linear")
model.addConstr(11*x1**2 + x2**2 >= 38, name="tastiness_squared")
model.addConstr(11*x1 + x2 >= 38, name="tastiness_linear")
model.addConstr(15*x1 + 15*x2 >= 27, name="umami")
model.addConstr(x1 - 9*x2 >= 0, name="protein_hotdog_relationship")
model.addConstr(16*x1 + 16*x2 <= 66, name="max_fiber")
model.addConstr(11*x1 + x2 <= 66, name="max_tastiness")
model.addConstr(15*x1 + 15*x2 <= 75, name="max_umami")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Protein bars: {x1.varValue}")
    print(f"Hot dogs: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
