
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
eggs = m.addVar(vtype=gp.GRB.INTEGER, name="eggs")
knishes = m.addVar(vtype=gp.GRB.INTEGER, name="knishes")
cornichons = m.addVar(vtype=gp.GRB.INTEGER, name="cornichons")

# Set objective function
m.setObjective(4.93*eggs**2 + 5.34*eggs*cornichons + 1.27*knishes**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*knishes**2 + 16*cornichons**2 >= 15)
m.addConstr(10*knishes + 19*cornichons >= 28)
m.addConstr(25*eggs + 10*knishes >= 30)
m.addConstr(25*eggs + 19*cornichons >= 19)
m.addConstr(2*eggs + 13*cornichons >= 29)
m.addConstr(2*eggs**2 + 16*cornichons**2 <= 79)
m.addConstr(2*eggs + 25*knishes + 16*cornichons <= 79)
m.addConstr(25*eggs + 10*knishes <= 42)
m.addConstr(10*knishes + 19*cornichons <= 70)
m.addConstr(25*eggs**2 + 19*cornichons**2 <= 91)
m.addConstr(25*eggs + 10*knishes + 19*cornichons <= 91)
m.addConstr(3*knishes**2 + 13*cornichons**2 <= 48)
m.addConstr(2*eggs**2 + 13*cornichons**2 <= 87)
m.addConstr(2*eggs + 3*knishes + 13*cornichons <= 87)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('eggs:', eggs.x)
    print('knishes:', knishes.x)
    print('cornichons:', cornichons.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

