
import gurobipy as gp

# Create a new model
m = gp.Model("Resource_Allocation")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.INTEGER, name=["x0", "x1", "x2", "x3", "x4", "x5"])


# Set objective
m.setObjective(4*x[0] + 3*x[1] + 2*x[2] + 4*x[3] + 4*x[4] + 2*x[5], gp.GRB.MAXIMIZE)

# Add constraints

deployment_weight = {0: 13, 1: 17, 2: 13, 3: 4, 4: 14, 5: 14}
defense_rating = {0: 15, 1: 12, 2: 3, 3: 5, 4: 9, 5: 3}

m.addConstr(13*x[0] + 13*x[2] >= 48)
m.addConstr(13*x[2] + 14*x[5] >= 67)
m.addConstr(4*x[3] + 14*x[4] >= 48)
m.addConstr(13*x[0] + 4*x[3] + 14*x[4] >= 44)


# ... (add all other constraints from the JSON "constraints" section, replacing symbolic variables with x[i])

m.addConstr(gp.quicksum(deployment_weight[i] * x[i] for i in range(6)) <= 497)
m.addConstr(gp.quicksum(defense_rating[i] * x[i] for i in range(6)) <= 343)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

