
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="mechanized_infantry_companies", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="engineer_platoons", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="reconnaissance_troops", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="air_defense_batteries", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)
x5 = m.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(4*x0 + 3*x1 + 2*x2 + 4*x3 + 4*x4 + 2*x5, gurobi.GRB.MAXIMIZE)

# Deployment weight constraints
m.addConstr(13*x0 + 17*x1 + 13*x2 + 4*x3 + 14*x4 + 14*x5 <= 497)
m.addConstr(13*x0 + 17*x1 <= 382)
m.addConstr(13*x0 + 14*x4 <= 353)
m.addConstr(13*x0 + 14*x5 <= 470)
m.addConstr(17*x1 + 14*x4 <= 148)
m.addConstr(13*x2 + 14*x5 <= 157)
m.addConstr(17*x1 + 13*x2 <= 363)
m.addConstr(13*x0 + 4*x3 <= 346)
m.addConstr(17*x1 + 4*x3 <= 340)
m.addConstr(17*x1 + 13*x2 + 4*x3 <= 367)
m.addConstr(17*x1 + 13*x2 + 14*x5 <= 310)
m.addConstr(13*x0 + 4*x3 + 14*x4 <= 447)
m.addConstr(17*x1 + 13*x2 + 14*x4 <= 428)
m.addConstr(13*x0 + 17*x1 + 14*x4 <= 455)
m.addConstr(13*x0 + 17*x1 + 14*x5 <= 225)
m.addConstr(13*x0 + 14*x4 + 14*x5 <= 157)

# Defensive capability rating constraints
m.addConstr(15*x0 + 12*x1 >= 39)
m.addConstr(12*x1 + 3*x5 >= 20)
m.addConstr(9*x4 + 3*x5 >= 55)
m.addConstr(5*x3 + 9*x4 >= 28)
m.addConstr(5*x3 + 3*x5 >= 38)
m.addConstr(15*x0 + 5*x3 >= 33)
m.addConstr(15*x0 + 5*x3 + 9*x4 >= 56)
m.addConstr(15*x0 + 3*x2 + 3*x5 >= 56)
m.addConstr(3*x2 + 9*x4 + 3*x5 >= 56)
m.addConstr(15*x0 + 12*x1 + 3*x5 >= 56)
m.addConstr(12*x1 + 3*x2 + 9*x4 >= 56)
m.addConstr(12*x1 + 3*x2 + 3*x5 >= 56)
m.addConstr(15*x0 + 3*x2 + 9*x4 >= 56)
m.addConstr(15*x0 + 3*x2 + 5*x3 >= 56)
m.addConstr(12*x1 + 5*x3 + 9*x4 >= 56)
m.addConstr(5*x3 + 9*x4 + 3*x5 >= 56)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Mechanized Infantry Companies: ", x0.varValue)
    print("Engineer Platoons: ", x1.varValue)
    print("Reconnaissance Troops: ", x2.varValue)
    print("Air Defense Batteries: ", x3.varValue)
    print("Water Purification Units: ", x4.varValue)
    print("Logistics Companies: ", x5.varValue)
else:
    print("No solution found")
