
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Resource_Allocation")

    # Create variables
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    jean_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    ringo_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    model.setObjective(4 * laura_hours + 6 * jean_hours + 2 * ringo_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * laura_hours + 16 * ringo_hours <= 101, "c0")
    model.addConstr(15 * jean_hours + 16 * ringo_hours <= 204, "c1")
    model.addConstr(3 * laura_hours + 15 * jean_hours + 16 * ringo_hours <= 204, "c2")
    model.addConstr(17 * jean_hours + 10 * ringo_hours <= 143, "c3")
    model.addConstr(6 * laura_hours + 17 * jean_hours <= 128, "c4")
    model.addConstr(6 * laura_hours + 17 * jean_hours + 10 * ringo_hours <= 191, "c5")
    model.addConstr(21 * laura_hours + 7 * ringo_hours <= 132, "c6")
    model.addConstr(21 * laura_hours + 19 * jean_hours <= 160, "c7")
    model.addConstr(21 * laura_hours + 19 * jean_hours + 7 * ringo_hours <= 160, "c8")
    model.addConstr(21 * laura_hours + 7 * ringo_hours <= 69, "c9")
    model.addConstr(21 * laura_hours + 5 * jean_hours <= 192, "c10")
    model.addConstr(21 * laura_hours + 5 * jean_hours + 7 * ringo_hours <= 192, "c11")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
