
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Laura", lb=0)
    x1 = model.addVar(name="hours_worked_by_Jean", lb=0)
    x2 = model.addVar(name="hours_worked_by_Ringo", lb=0)

    # Define the objective function
    model.setObjective(4*x0 + 6*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x0 <= 270)
    model.addConstr(6*x0 <= 204)
    model.addConstr(21*x0 <= 197)
    model.addConstr(21*x0 <= 198)
    model.addConstr(15*x1 <= 270)
    model.addConstr(17*x1 <= 204)
    model.addConstr(19*x1 <= 197)
    model.addConstr(5*x1 <= 198)
    model.addConstr(16*x2 <= 270)
    model.addConstr(10*x2 <= 204)
    model.addConstr(7*x2 <= 197)
    model.addConstr(7*x2 <= 198)
    model.addConstr(3*x0 + 16*x2 <= 101)
    model.addConstr(15*x1 + 16*x2 <= 204)
    model.addConstr(3*x0 + 15*x1 + 16*x2 <= 204)
    model.addConstr(17*x1 + 10*x2 <= 143)
    model.addConstr(6*x0 + 17*x1 <= 128)
    model.addConstr(6*x0 + 17*x1 + 10*x2 <= 191)
    model.addConstr(21*x0 + 7*x2 <= 132)
    model.addConstr(21*x0 + 19*x1 <= 160)
    model.addConstr(21*x0 + 19*x1 + 7*x2 <= 160)
    model.addConstr(21*x0 + 7*x2 <= 69)
    model.addConstr(21*x0 + 5*x1 <= 192)
    model.addConstr(21*x0 + 5*x1 + 7*x2 <= 192)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Jean: ", x1.varValue)
        print("Hours worked by Ringo: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
