
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_stuff")

    # Create variables
    headsets = model.addVar(vtype=GRB.INTEGER, name="headsets")
    packs_of_paper = model.addVar(vtype=GRB.INTEGER, name="packs_of_paper")


    # Set objective function
    model.setObjective(6 * headsets * packs_of_paper + 4 * headsets, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * headsets + 17 * packs_of_paper >= 30, "sustainability_min")
    model.addConstr(13 * headsets + 11 * packs_of_paper >= 55, "usefulness_min")
    model.addConstr(-2 * headsets + packs_of_paper >= 0, "constraint3")
    model.addConstr((15 * headsets) * (15*headsets) + (17 * packs_of_paper) * (17*packs_of_paper) <= 68, "sustainability_squared_max")
    model.addConstr(15 * headsets + 17 * packs_of_paper <= 68, "sustainability_max")
    model.addConstr(13 * headsets + 11 * packs_of_paper <= 85, "usefulness_max")



    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Number of headsets: {headsets.x}")
        print(f"Number of packs of paper: {packs_of_paper.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
