
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="headsets")
x2 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper")

# Set objective function
m.setObjective(6*x1*x2 + 4*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 17*x2 >= 30, "Sustainability Score Constraint")
m.addConstr(13*x1 + 11*x2 >= 55, "Usefulness Rating Constraint")
m.addConstr(-2*x1 + x2 >= 0, "Linear Combination Constraint")
m.addConstr(15*x1 + 17*x2 <= 68, "Combined Sustainability Score Constraint")
m.addConstr(13*x1 + 11*x2 <= 85, "Combined Usefulness Rating Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Headsets:", x1.x)
    print("Packs of Paper:", x2.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found")
