
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='headsets', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='packs of paper', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6 * x1 * x2 + 4 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15 * x1 + 17 * x2 >= 30)
    model.addConstr(13 * x1 + 11 * x2 >= 55)
    model.addConstr(-2 * x1 + x2 >= 0)
    model.addConstr((15 * x1) ** 2 + (17 * x2) ** 2 <= 68)
    model.addConstr(15 * x1 + 17 * x2 <= 68)
    model.addConstr(13 * x1 + 11 * x2 <= 85)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Headsets: ', x1.varValue)
        print('Packs of paper: ', x2.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
